/*****************************************************************************************
 *                                                                                       *
 * OpenSpace                                                                             *
 *                                                                                       *
 * Copyright (c) 2014-2017                                                               *
 *                                                                                       *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this  *
 * software and associated documentation files (the "Software"), to deal in the Software *
 * without restriction, including without limitation the rights to use, copy, modify,    *
 * merge, publish, distribute, sublicense, and/or sell copies of the Software, and to    *
 * permit persons to whom the Software is furnished to do so, subject to the following   *
 * conditions:                                                                           *
 *                                                                                       *
 * The above copyright notice and this permission notice shall be included in all copies *
 * or substantial portions of the Software.                                              *
 *                                                                                       *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,   *
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A         *
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT    *
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF  *
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE  *
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.                                         *
 ****************************************************************************************/

#ifndef __OPENSPACE_MODULE_NEWHORIZONS___HONGKANGPARSER___H__
#define __OPENSPACE_MODULE_NEWHORIZONS___HONGKANGPARSER___H__

#include <modules/newhorizons/util/sequenceparser.h>

namespace openspace {

class HongKangParser : public SequenceParser {
public:
    HongKangParser();
    HongKangParser(std::string name, std::string fileName, std::string spacecraft,
        ghoul::Dictionary dictionary, std::vector<std::string> potentialTargets);

    bool create() override;
    void findPlaybookSpecifiedTarget(std::string line, std::string& target);

private:
    double getMetFromET(double et);
    double getETfromMet(std::string timestr);
    double getETfromMet(double met);

    bool augmentWithSpice(Image& image,  std::string spacecraft, 
        std::vector<std::string> payload, std::vector<std::string> potentialTargets);

    std::string _defaultCaptureImage;
    double _metRef = 299180517;

    std::string _name;
    std::string _fileName;
    std::string _spacecraft;
    std::map<std::string, std::unique_ptr<Decoder>> _fileTranslation;
    std::vector<std::string> _potentialTargets;
};

} // namespace openspace

#endif // __OPENSPACE_MODULE_NEWHORIZONS___HONGKANGPARSER___H__
